/*
  EchoBot

  This example shows how to program a Telegram Bot
  that echoes your messages.

  For a step-by-step tutorial visit:
  https://create.arduino.cc/projecthub/Arduino_Genuino/telegram-bot-library-ced4d4

  Updated 19 May 2016
  by Tommaso Laterza

  This example code is in the public domain.

*/
#include<WiFiSSLClient.h>
#include <WiFi101.h>
#include <SPI.h>
#include <TelegramBot.h>
#include <dht11.h>
dht11 DHT;
#define DHT11_PIN 6
String temperature ,hum;

// Initialize Wifi connection to the router
char ssid[] = "";             // your network SSID (name)
char pass[] = "";           // your network key


// Initialize Telegram BOT
const char BotToken[] = "TOKEN";
const char BotName[] = "Nome del Bot";
const char BotUsername[] = "usernamebot";


WiFiSSLClient client;
TelegramBot bot (BotToken, BotName, BotUsername, client);
TelegramKeyboard keyboard_one;

void setup() {

  Serial.begin(9600);
 // while (!Serial) {}
 delay(3000);


  // attempt to connect to Wifi network:
  //Serial.print("Connecting Wifi: ");
  //Serial.println(ssid);
  while (WiFi.begin(ssid, pass) != WL_CONNECTED) {
    //Serial.print(".");
    delay(500);
  }
  //Serial.println("");
  //Serial.println("WiFi connected");

 const char* row_one[] = {"temp", "hum"};
  keyboard_one.addRow(row_one, 2);
  bot.begin();

}

void loop() {
int chk;
  //Serial.print("DHT11, \t");
  chk = DHT.read(DHT11_PIN);    // READ DATA
  hum = String(DHT.humidity);
  temperature= String(DHT.temperature);
  switch (chk){
    case DHTLIB_OK:  
                //Serial.println("OK,\t");
                //Serial.println("Temp: "+temperature);
                //Serial.println("Hum: "+hum);  
                break;
    case DHTLIB_ERROR_CHECKSUM: 
                //Serial.print("Checksum error,\t"); 
                break;
    case DHTLIB_ERROR_TIMEOUT: 
                //Serial.print("Time out error,\t"); 
                break;
    default: 
                //Serial.print("Unknown error,\t"); 
                break;
  }


    message m = bot.getUpdates(); // Read new messages
    if ( m.chat_id != 0 ){ // Checks if there are some updates

     if (m.text=="temp") bot.sendMessage(m.chat_id,temperature+"°C",keyboard_one);
     if (m.text=="hum") bot.sendMessage(m.chat_id,hum+"%",keyboard_one);  
      //Serial.println(m.text);
  
    } else {
      //Serial.println("no new message");
    }
 delay(500);
}
